;----------------------------------------------------------------------------
;
;    MODULE NAME:   MAKEMSI.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.98  $
;          $Date:   21 Nov 2007 17:32:20  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/MAKEMSI.mm.pvcs  $
;      COPYRIGHT:   (C)opyright Dennis Bareis, Australia, 2003
;                   All rights reserved.
;
; DESCRIPTION
; ~~~~~~~~~~~
; This is the source script actually used to build the MAKEMSI MSI.
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;--- I am not maintaining VERSION info in the ".VER" file -------------------
;----------------------------------------------------------------------------
#include "MmVersion.mmh"         ;;Just include the MAKEMSI version #
#DefineRexx ''
   ;--- Manipulate the MAKEMSI version number into a product version number ---
   @@Ver = '<$MAKEMSI_VERSION>'
   parse var @@Ver @@YY '.' +1 @@DDD +3 @@Fix
   @@YY  = right(@@YY,  2, '0');
   @@DDD = right(@@DDD, 3, '0');
   if  @@Fix = '' then
       @@Fix = '0'
   else
   do
       @@Fix = translate(@@Fix);
       if  pos(@@Fix, xrange('A', 'Z')) = 0 then
           error('Invalid version fix letter of "' || @@Fix || '"');
       @@Fix = c2d(translate(@@Fix)) - c2d('A') + 1
   end;
   @@Fix = right(@@Fix, 4, '0');

   ;--- The "VER" file will refer to this -----------------------------------
   call MacroSet 'HistoryVersion', @@YY || '.0.' || @@DDD || '.' || @@Fix
#DefineRexx
#undef MAKEMSI_VERSION


;--------------------------------------------------------------------------------
;--- Replace the default left side (vertical) graphic defined by "DENNIS.MMH" ---
;--------------------------------------------------------------------------------
#define? UISAMPLE_DIALOG_FILE_dlgbmp     LeftSide-MakeMsi.bmp


;----------------------------------------------------------------------------
;--- I will be using this below... ------------------------------------------
;----------------------------------------------------------------------------
;---[4Doco.ZipDirectoryTreeImageMacro]---
#(
    #define UnzipImage                                  ;;Version 07.146
    #evaluate ^^ ^<$@@Rexx2UnzipDirectoryTree {$?}>^
#)
#define? UnzipImageOutputColor  {CYAN}          ;;Output of the unzipping process..
#DefineRexx '@@Rexx2UnzipDirectoryTree'
    ;--- Get parameters -----------------------------------------------------
    {$!:ZIPFILE,DIR,CLEAR,Options}         ;;Validate passed parameters
    @@ZipFile              = '{$ZipFile}';
    @@DestinationDirectory = '{$Dir}';
    if  FileQueryExists(@@ZipFile) = '' then
        error('The zip file "' || @@ZipFile || '" doesn''t exist!');

    ;--- Almost always want to start with a clean directory -----------------
    if  '{$Clear=^Y^}' = 'N' then             ;;Allow for multiple zips unpacking into a single location.
        call Info 'Adding unpacked image to the destination directory.'
    else
    do
        ;--- We expect to start from scratch --------------------------------
        call Info 'Clearing the unzip destination directory'
        call AddressCmd 'rd "' || @@DestinationDirectory || '" /q /s >nul <$Stderr2Out>'

        ;--- We will need to create the directory ---------------------------
        call AddressCmd 'md "' || @@DestinationDirectory || '" >nul <$Stderr2Out>'
    end;

    ;--- Unzip --------------------------------------------------------------
    call Info 'Unpacking ZIP (' || @@ZipFile || ')'
    call ColorCfg '?UNZIPSRCIMG', '<$UnzipImageOutputColor>';
    call ColorSet '?UNZIPSRCIMG';
    @@Rc = AddressCmd('iunzip.exe {$Options=^-o^} "' || @@ZipFile || '" -d "' || @@DestinationDirectory || '"')
    call ColorSet 'DEFAULT';
    if  @@Rc <> 0 then
        error('The unzip of "' || @@ZipFile || '" failed with return code ' || @@Rc);
    else
    do
        ;--- Make sure we find at least one (non-hidden) file (double check) ---
        call Files4Mask @@DestinationDirectory || "\*.*", "@@ZipImage", "Y", "N"
        if  @@ZipImage.0 = 0 then
            error('The unzip of "' || @@ZipFile || '" probably failed as no files seem to have been extracted to the directory "' || @@DestinationDirectory || '"');
    end;
#DefineRexx
;---[4Doco.ZipDirectoryTreeImageMacro]---



;----------------------------------------------------------------------------
;--- We want link to installation installations on the "welcome dialog" -----
;----------------------------------------------------------------------------
#define UISAMPLE_ADD_INSTALL_INSTRUCTIONS_BUTTON_URL http://makemsi-manual.dennisbareis.com/install.htm
#define HTTP_MAKEMSI_CHANGE_HISTORY                  http://makemsi-manual.dennisbareis.com/changehistory.htm


#define UISAMPLE_ADD_INSTALL_INSTRUCTIONS_BUTTON_TOOLTIP \
        See MAKEMSI install instructions (online)
;**    [CommentBlockStart     (20 March 2006 18:03:24, Dennis)
;**+----------------------------------------------------------------------
;**|#define UISAMPLE_ADD_INSTALL_INSTRUCTIONS_BUTTON_TOOLTIP \
;**|        <$UISAMPLE_ADD_INSTALL_INSTRUCTIONS_BUTTON_URL>
;**|
;**+----------------------------------------------------------------------
;**    CommentBlockEnd]       (20 March 2006 18:03:24, Dennis)

;----------------------------------------------------------------------------
;--- Load Common Definitions and MAKEMSI Support ----------------------------
;----------------------------------------------------------------------------
#define  COMPANY_SUMMARY_SCHEMA           110      ;;Minimum v1.1 Installer
#include "MAKEMSI.MM.H"


;----------------------------------------------------------------------------
;--- External HTTP Links ----------------------------------------------------
;----------------------------------------------------------------------------
;#include "MAKEMSI.D" "[External-Links]"
#define HTTP_MSI_CHM_START_PAGE http://msdn2.microsoft.com/en-us/library/aa372866.aspx


;----------------------------------------------------------------------------
;--- Don't want to affect any existing rexx interpreters etc -------------
;----------------------------------------------------------------------------
#define REXX_ProgID      ReginaScript4MM   ;;Don't touch "ReginaScript"


;----------------------------------------------------------------------------
;--- Default Install dir ----------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="INSTALLDIR"      Dir="C:\Program Files\MakeMsi" Change="\">


;----------------------------------------------------------------------------
;--- PER USER Install dir ---------------------------------------------------
;----------------------------------------------------------------------------
<$Component "INSTALLDIR_PERUSER" Create="Y" Directory_="<$AnyDir>" CU="Y">
    <$DirectoryTree Key="INSTALLDIR_PERUSER" Dir="[AppDataFolder]\MAKEMSI" MAKE="Y" REMOVE="Y">
<$/Component>


;----------------------------------------------------------------------------
;--- Name Icons uniquely to work around windows bugs ------------------------
;----------------------------------------------------------------------------
#option PUSH DefineMacroReplace=ON
#define RandomishIconBit  - <??@@Ver> - <?=time('s')> ;;Prevents Windows accessing old icons (incorrectly)
#define MM.ICO           MM <$RandomishIconBit>.ICO
#define MMH.ICO          MMH <$RandomishIconBit>.ICO
#define VER.ICO          VER <$RandomishIconBit>.ICO
#define 4MM.ICO          4MM (rexx) <$RandomishIconBit>.ICO
#define RE4MM.ICO        RE4MM <$RandomishIconBit>.ICO
#define IniMM.ICO        IniMM <$RandomishIconBit>.ICO
#define IDT.ICO          IDT <$RandomishIconBit>.ICO
#define CMDPROMPT.ICO    CMDPRMT <$RandomishIconBit>.ICO
#option POP


;----------------------------------------------------------------------------
;--- MAKEMSI.DLL needs "msvbvm60.dll" (may not exist, thats OK) -------------
;----------------------------------------------------------------------------
<$FileFind File="MSVBVM60.DLL" Property="MSVBVM60.DLL" PATH="[WindowsFolder]" Depth="1" DEFAULT="">


;----------------------------------------------------------------------------
;--- Exclude some ".MMH" ----------------------------------------------------
;----------------------------------------------------------------------------
<$FilesExclude "*dutch*.mmh"          EXLIST="XL_MMH">
<$FilesExclude "selfreg_.mmh"         EXLIST="XL_MMH">
<$FilesExclude "SelfRegImport.MMH"    EXLIST="XL_MMH">
<$FilesExclude "HotFix4WinXpSp2.mmh"  EXLIST="XL_MMH">   ;;Sample Header


;----------------------------------------------------------------------------
;--- Extensions -------------------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="USER_SUPPLIED_EXTENSIONS"  Dir="[INSTALLDIR]\UserExtns">
<$Component "USER_SUPPLIED_EXTENSIONS" Create="Y" Directory_="USER_SUPPLIED_EXTENSIONS">
   ;--- Readme.txt ----------------------------------------------------------
   #( '<?NewLine>'
        #define /ReadMe+ProgramFilesWarning

        <?NewLine><?NewLine><?NewLine>
        ================================================
        ==================[ WARNING ]===================
        ================================================
        Its possible you will not be able to build the samples from the
        "program files" directory as not all users will have write access here.<?NewLine>
        If you can't build anything then please copy the samples to a your
        "My Documents" and try again.
        <$/ReadMe>
   #)
   <$ReadMe KeyFile=Y>
       This directory tree contains MAKEMSI extensions supplied and
       maintained by others.

       While I do want to know of any problems you should probably
       contact the author with comments or for help if possible.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>


;----------------------------------------------------------------------------
;--- Extensions: Julian Onions ----------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="BY_JULIAN_ONIONS"  Dir="[USER_SUPPLIED_EXTENSIONS]\JulianOnions">
<$Component "BY_JULIAN_ONIONS" Create="Y" Directory_="BY_JULIAN_ONIONS">
    <$FileComment Comment="Supplied and maintained by Julian Onions (thanks).">
        <$File Source="patch[JulianOnions].mmh"     Destination="patch.mmh" EXLIST="XL_MMH" KeyPath="Y">
        <$File Source="patch[JulianOnions].mmh.txt" Destination="patch.txt">
    <$/FileComment>
<$/Component>


;----------------------------------------------------------------------------
;--- We use the freeware (and distributable) RUNPROCESS.EXE -----------------
;----------------------------------------------------------------------------
<$Component "RUNPROCESS.EXE" Create="Y" Directory_="INSTALLDIR">
    <$FileComment Comment="Freeware tool by Frank P. Westlake.">
        <$File Source="RunProcess.exe"  Destination="RunProcess_.exe" KeyPath="Y">
        <$File Source="RunProcess.txt"  Destination="RunProcess_.txt">
    <$/FileComment>
<$/Component>


;----------------------------------------------------------------------------
;--- Main Files -------------------------------------------------------------
;----------------------------------------------------------------------------
<$Component "MainFiles" Create="Y" Directory_="INSTALLDIR">
   ;--- Add ".MMH" (header) files -------------------------------------------
   <$Files "MAKEMSI.MMH"       EXLIST="XL_MMH" Comment=^Include this to create an MSI with full control (most people will want to use "DEPT.MMH" instead).^ KeyFile="*" >
   <$Files "MAKEMSM.MMH"       EXLIST="XL_MMH" Comment=^Include this to create a MSM (merge module).^>
   <$Files "OPENMSI.MMH"       EXLIST="XL_MMH" Comment=^Include this to update an existing Windows Installer database of any type (not just MSI)^>
   <$Files "ICE.MMH"           EXLIST="XL_MMH" Comment=^Include this to create/update an CUB file (ICE validator)^>
   <$Files "ME.MMH"            EXLIST="XL_MMH" Comment=^An example (template?) for a file it is recommended you create to front end "DEPT.MMH" and "COMPANY.MMH" for MSI creation. A large company could probably have two front ends, one for company options and branding and the other for individual team options and branding. See "DENNIS.MMH" for a more complex example (its actually what I use).^>
   <$Files "DENNIS.MMH"        EXLIST="XL_MMH" Comment=^A more complex branding and configuration file than "ME.MMH".^>
   <$Files "HotFix.MMH"        EXLIST="XL_MMH" Comment=^A hotfix framework (not automatically included by MAKEMSI). Definately "beta" code at best at this stage, please report improvements or issues.^>
   <$Files "FreeExtractor.MMH" EXLIST="XL_MMH" Comment=^A MSI2EXE framework based on the open source FreeExtractor.^>
   <$FileComment Comment="One of the many supporting MAKEMSI Header Files. Do not refer to this file in your scripts (other headers load these as required)!">
        <$Files "*.mmh"   EXLIST="XL_MMH" KeyFile="*">
        <$Files "AdsiDumpObject.H" Comment="Needed by ADSI.MMH">
   <$/FileComment>

   ;--- Used By DENNIS.MMH --------------------------------------------------
   <$File Source="Aust_DB.bmp"         Comment=^My replacement bitmap for top right of install dialog.^>
   <$File Source="Aust_DB.ico"         Comment=^Sample icon as used by Dennis Bareis.^>
   <$File Source="LeftSide.bmp"        Comment=^My replacement bitmap for the left side of some dialogs (like "welcome" and "finish" dialogs).^>
   <$File Source="LeftSide-Dennis.bmp" Comment=^The graphic that "DENNIS.MMH" (my MSIs) use (please don't use.^>
   <$File Source="LeftSide-Purple.bmp" Comment=^A alternative graphic you can use.^>
   <$File Source="PrettyBanner.bmp"    Comment=^Replacement "white bar" on top of install dialogs.^>

   ;--- Add other support files, bitmaps, filters etc -----------------------
   <$File Source="PrettyMd5.VH"       Comment=^Common VBSCRIPT functions to create a pretty MD5 given an installer MD5 record.^>
   <$File Source="MakeMsi.FLT"        Comment=^The base validation filter (removed "stupid" messages we don't care about).^>
   <$File Source="white.bmp"          Comment=^Replacement "white bar" on top of install dialogs.^>
   <$File Source="ErrorTemplates.TXT" Comment=^The default "error templates" which are used to format standard Windows Installer errors if an MSI build fails.^>
   <$File Source="MmDefaultProductIcon.ico"    Comment=^Default Product Icon. I use one because I have seen a Windows Installer or Add remove bug cause the first icon to be used if no product icon defined!^>
   <$File Source="MmCustomSetup.ico"           Comment=^Better custom setup icon than that provided by "UISAMPLE.MSI".^>
   <$File Source="UiSample.msi"                Comment=^Template MSI used by "COMPANY.MMH".^>
   <$File Source="MsmTemplate-Schema-120.MSM"  Comment=^Template MSM used by "MAKEMSM.MMH".^>
   <$File Source="out\MonitorUninstallKey.VBS" Comment=^Used to report what install key a product uses.^>
   <$File Source="out\IisDumpMetaBase.VBS"     Comment=^Run via CSCRIPT to dump the IIS metabase (redirect output).^>
   <$File Source="<?=FindFile('HTMLPRE.IH')>" Comment=^Enables source code to be listed in the generated HTML report.^>
<$/Component>


;----------------------------------------------------------------------------
;--- Some Shortcuts ---------------------------------------------------------
;----------------------------------------------------------------------------
<$Component "Shortcuts" Create="Y" Directory_="INSTALLDIR" CU="Y">
   ;--- OPEN Installation DIR Shortcut --------------------------------------
   <$DirectoryTree Key="SCDIR_MAKEMSI" Dir="[ProgramMenuFolder]\MakeMSI" Remove="Y">
   #(
       <$Shortcut
                   Dir="SCDIR_MAKEMSI"
                Target="[INSTALLDIR]"
                 Title="Open Installation directory"
            Description=^Opens the "MAKEMSI" installation directory.^
       >
   #)

   ;--- Just execute "MonitorUninstallKey.VBS" ------------------------------
   <$Icon KEY="@MonitorUninstallKey" ".\MonitorUninstallKey.ico">
   #(
       <$Shortcut
                   Dir="SCDIR_MAKEMSI"
                Target="[INSTALLDIR]MonitorUninstallKey.VBS"
                 Title="Watch Uninstall Keys"
           Description=^Very handy if you use the "WrapInstall" command! Compares uninstall keys from a BEFORE and AFTER snapshot.^
                  Icon="@MonitorUninstallKey"
       >
   #)

   ;--- Some WEB directories ------------------------------------------------
   <$DirectoryTree Key="SCDIR_INTERNET_LINKS" Dir="[SCDIR_MAKEMSI]\Internet Links" Remove="Y">
   #(
       <$Shortcut
                   Dir="SCDIR_INTERNET_LINKS"
                Target="<$MAKEMSI_HOMEPAGE>"
                 Title="MAKEMSI Home Page"
           Description=^Opens the "MAKEMSI" homepage on the internet (<$MAKEMSI_HOMEPAGE>).^
       >
   #)
   #define PPWIZARD_HOMEPAGE <?PpwizardAuthorBaseWebDir>ppwizard.htm
   #(
       <$Shortcut
                   Dir="SCDIR_INTERNET_LINKS"
                Target="<$PPWIZARD_HOMEPAGE>"
                 Title="PPWIZARD Home Page"
           Description=^Opens the "PPWIZARD" homepage on the internet (<$PPWIZARD_HOMEPAGE>).^
       >
   #)
<$/Component>
#(
    ;--- Macro for Windows Installer doco link (I'm creating twice) ---------
    #define Link2WindowsInstallerDoco
    <$Component "ShortCutDocoWindowsInstaller_{$#1}" Create="Y" Directory_="INSTALLDIR" CU="Y">
       #(
           <$Shortcut
                       Dir="{$#1}"
                   Target="<$HTTP_MSI_CHM_START_PAGE>"
                     Title="Windows Installer Documentation"
               Description="Online documentation on Microsoft web site"
;;                    Icon="@Help"
                   WorkDir="INSTALLDIR"
           >
       #)
    <$/Component>
#)
<$Link2WindowsInstallerDoco "SCDIR_INTERNET_LINKS">




;----------------------------------------------------------------------------
;--- Operating specific files -----------------------------------------------
;----------------------------------------------------------------------------
<$Component "ForNT" Create="Y" Directory_="INSTALLDIR" Condition="not Version9X">
   <$File Source="MM.CMD"   KeyPath="Y" Comment='A small "sample" batch file to build an MSI (eventually I will also add explorer right click option for building MSIs).'>
   <$File Source="ConSetBuffer.exe"     Comment=^A free utility by Frank P. Westlake to set buffer size.^>
<$/Component>
<$Component "ForDOS" Create="Y" Directory_="INSTALLDIR" Condition="Version9X">
   <$File Source="MM9X.BAT" KeyPath="Y" Destination="MM.BAT"  Comment='A small "sample" batch file to build an MSI (eventually I will also add explorer right click option for building MSIs).'>
   <$File Source="MM9X.PPW" Comment='Used by MM9X.BAT (alias "MM.BAT").'>
<$/Component>


;----------------------------------------------------------------------------
;--- SAMPLES - ROOT DIR -----------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="SAMPLESDIR"  Dir="[INSTALLDIR]\Samples">
    #define SAMPLESRELDIR_TRYME                   TryMe
    #define SAMPLESRELDIR_OTHER                   Other
    #define SAMPLESRELDIR_MAKEMSI_SOURCE          <$SAMPLESRELDIR_OTHER>\MakeMSI Source
    #define SAMPLESRELDIR_TRYME_CREATE_MSI        <$SAMPLESRELDIR_TRYME>\Create MSI Installers
    #define SAMPLESRELDIR_TRYME_CREATE_MSM        <$SAMPLESRELDIR_TRYME>\Create Merge Modules
    #define SAMPLESRELDIR_TRYME_CREATE_CUB        <$SAMPLESRELDIR_TRYME>\Create Validation Suites
    #define SAMPLESRELDIR_TRYME_UPDATE_DB         <$SAMPLESRELDIR_TRYME>\Update Databases (including MSI)
<$Component "SAMPLESDIR" Create="Y" Directory_="SAMPLESDIR">
   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe KeyFile=Y>
       This directory tree contains all example scripts or other files
       installed by MAKEMSI.

       I recommend that you at least have a quick look at each one as each
       one demonstrates something that others don't.


       DIRECTORY "<$SAMPLESRELDIR_TRYME_CREATE_MSI>"
       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       This contains "TRYME.MM" and many other scripts that you can execute
       to build complete MSIs.
       Simply right click on any ".MM" file and select a build option.

       I highly recommend that you at least build the "TryMe.MM" MSI.


       DIRECTORY "<$SAMPLESRELDIR_TRYME_CREATE_MSM>"
       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       If you are interested in building merge modules then this directory
       is for you!


       DIRECTORY "<$SAMPLESRELDIR_TRYME_CREATE_CUB>"
       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       This directory contains a sample creation and/or update to an MSI
       validation suite.

       It demonstrates how to add your own validations.


       DIRECTORY "<$SAMPLESRELDIR_TRYME_UPDATE_DB>"
       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       If you are more interested in the manipulation of already existing
       MSI (or other windows installer databases) then first build "TryMe.MM"
       (see above) then "run" the "Tweek.MM" script.

       This script manipulates an MSI but this could have been any type of
       windows Installer database. It also demonstates some pre and post
       processing.


       DIRECTORY "<$SAMPLESRELDIR_MAKEMSI_SOURCE>"
       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       This contains the complete source for the MAKEMSI MSI you have
       installed. It is provided as a more complex example which demonstrates
       a number of interesting things.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>

;----------------------------------------------------------------------------
;--- SAMPLES - TRYME/OTHER -------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="SAMPLESDIR_TRYME"  Dir="[SAMPLESDIR]\<$SAMPLESRELDIR_TRYME>">
<$DirectoryTree Key="SAMPLESDIR_OTHER"  Dir="[SAMPLESDIR]\<$SAMPLESRELDIR_OTHER>">
<$Component "SAMPLESDIR_TRYME" Create="Y" Directory_="SAMPLESDIR_TRYME">
   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe KeyFile=Y>
       This directory tree contains scripts which in almost all cases can
       be immediately built without any effort.

       The odd one or two (as documented in any other "readme" may require
       some minor initialization to have taken place).
   <$/ReadMe+ProgramFilesWarning>
<$/Component>
<$Component "SAMPLESDIR_OTHER" Create="Y" Directory_="SAMPLESDIR_OTHER">
   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe KeyFile=Y>
       This directory tree contains scripts which I don't really expect you
       to be able to build (without major effort at least).

       The samples are provided purely as example code.
       DO NOT TRY TO BUILD THEM.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>




;----------------------------------------------------------------------------
;--- SAMPLES - MAKEMSI SOURCE -----------------------------------------------
;----------------------------------------------------------------------------
#define MAKEMSI_SOURCECODE  makemsi.mm;makemsi.mm.h;makemsi.ver;LeftSide-MakeMsi.bmp
#define MSIDIFF_SOURCECODE  msidiff.mm;msidiff.ver
<$DirectoryTree Key="SAMPLESDIR_MAKEMSI_SOURCE"  Dir="[SAMPLESDIR]\<$SAMPLESRELDIR_MAKEMSI_SOURCE>">
<$Component "SamplesMakeMsiSource" Create="Y" Directory_="SAMPLESDIR_MAKEMSI_SOURCE">
   ;--- Add the source ------------------------------------------------------
   <$Files "<$MAKEMSI_SOURCECODE>" Comment="This is the source actually used to build this MAKEMSI tool's MSI. It will fail if you try to use it..." KeyFile="*">
   <$Files "<$MSIDIFF_SOURCECODE>" Comment="This is the source actually used to build this MSIDIFF tool's MSI. It will fail if you try to use it..." KeyFile="*">

   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       This directory contains the actual MAKEMSI source code used to build the
       currently installed release.

       You will not be able to successfully build this, it is provided as
       a sample only.

       For something as big as the MAKEMSI script if I wasn't trying to also
       provide it as a "real life" sample I'd have split it up into separate
       ".MMH" modules with at least each feature being in its own file.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>


;----------------------------------------------------------------------------
;--- SAMPLES - TRYME MSI ----------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="SAMPLESDIR_TRYME_CREATE_MSI"  Dir="[SAMPLESDIR]\<$SAMPLESRELDIR_TRYME_CREATE_MSI>">
<$Component "SAMPLESDIR_TRYME_CREATE_MSI" Create="Y" Directory_="SAMPLESDIR_TRYME_CREATE_MSI">
   ;--- The samples ---------------------------------------------------------
   <$File Source="TryMe.MM"                            Comment=^A very simple sample and test script which you can try to build an MSI with. I recommend you try to build it before making any changes or building your own.^ KeyPath="Y">
   <$File Source="TryMeShortcuts.MM"                   Comment=^Demonstrates shortcut creation.^>
   <$File Source="TryMeUpdateRegistry00-99.MM"         Comment=^Demonstrates finding a "suitable" registry location (conditional logic without custom action).^>
   <$File Source="TryMeTaskSchedules.MM"               Comment=^A sample that uses JT.EXE to create task schedules.^>
   <$File Source="TryMeUserInputUsed2CreateFile.MM"    Comment=^A sample that asks for user input at BUILD time.^>
   <$File Source="TryMeCreateIisSite.MM"               Comment=^A sample that demonstrates creating IIS web sites.^>
   <$File Source="TryMeDllCustomAction.MM"             Comment=^A sample that demonstrates a DLL custom action.^>
   <$File Source="TryMeUseMergeModule.MM"              Comment=^A sample which uses the merge module created with "TryMeCreateMergeModule.mm".^>
   <$File Source="TryMeWithUserDialog.MM"              Comment=^The same as "TryMe.MM" but also inserts a user dialog into the user interface.^>
   <$File Source="TryMeWithNonAdvShortcutPlusMore.MM"  Comment=^Most advanced sample installed, creates non-advertised shortcut plus demos other things.^>
   <$File Source="TryMeWithNoRootFeature.MM"           Comment=^Demonstrates disabling "complete" feature creation and so doco manipulations.^>
   <$File Source="TryMeWithMultipleMedia.MM"           Comment=^Demonstrates generating MSI with external CABs over myultiple media.^>
   <$File Source="TryMeWithFixedGuids.MM"                      Comment=^Demonstrates control over the GUIDs used (required if upgrade types other than "major" are desired).^>
   <$File Source="TryMeAddVersionKeywordAndLaunchCondition.MM" Comment=^Demonstrates adding a version file keyword and adding launch conditions via the VERSION file!^>
   <$File Source="TryMeLoadDirTreeMaintainingAttributes.MM"    Comment=^Demonstrates loading a whole tree of files while maintaining both file and folder attributes.^>
   <$File Source="TryMeCreate[START]OfMsiFromScratch.MM"       Comment=^Demonstrates creation of MSI with full control (no framework). It generates a partial MSI which will not install.^>
   <$File Source="TryMe.VER" Comment=^The version file for the sample/test scripts "TryMe.MM" and "TryMeShortcuts.MM" etc!^>
   <$File Source="TryMe.ICO" Comment=^Icon only used by the MSI created by "TryMeShortcuts.MM".^>
   <$File Source="TryMe.rtf" Comment=^Licence file (specified by "TryMe.ver").^>

   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       This directory contains sample MSI creation scripts which you
       should be able to execute to successfully build a ".MSI" file
       Right click on the ".MM" file and select a build option.

       I suggest that since "TRYME.MM" is the simplest script that you
       try it first. All the scripts use the same "TryMe.VER" and other
       resources (as these would be near identical and are not what I
       am demonstrating).

       The scripts are supplied so that within minutes of installing
       MAKEMSI you should have been able to create your first working
       MSIs. Generally the hardest part with anything new is getting
       the first "item" working.
       Most scripts don't require any preparation but if any is required
       they will tell you.

       The scripts provide a working starting point which you can modify
       to test changes while you are learning MAKEMSI. When trying
       different commands you should expect error messages while learning,
       I have gone to a lot of work to provide enough detail with good
       messages so that you should be able to solve it. If not send me the
       script and error details and I'll probably improve it.

       MAKEMSI does not validate absolutely everything up front and so it
       is possible that a build will fail during the execution of the
       VBS it generates. If so it will identify the exact location which
       should enable you to work out what faulty imput you supplied on
       which command.
       As I detect these I am improving up front validation to remove them
       (on the theory that anything seen or reported may be a common issue
       deserving more and better validation).
       You are expected to test your MSI like any other piece of software,
       given the same script and environment MAKEMSI will consistently
       build a "correct" (or "wrong" MSI).
       Think of a compiler (Garbage in means Garbage out).
   <$/ReadMe+ProgramFilesWarning>
<$/Component>



;----------------------------------------------------------------------------
;--- SAMPLES - TRYME MSI (DUTCH) --------------------------------------------
;---------------------------------------------------------------------------
<$DirectoryTree Key="SAMPLESRELDIR_TRYME_CREATE_MSI_DUTCH"  Dir="[SAMPLESDIR_TRYME_CREATE_MSI]\Localisation to Dutch">
<$Component "SAMPLESRELDIR_TRYME_CREATE_MSI_DUTCH" Create="Y" Directory_="SAMPLESRELDIR_TRYME_CREATE_MSI_DUTCH">
    ;--- The main files which I PVCS along with all others as individual files ---
    #define DUTCH.ZIP  .\Dutch.NLD.zip
    <$FilesExclude "<$DUTCH.ZIP>" EXLIST="DUTCH.ZIP">
    <$Files "*Dutch*" Comment=^Dutch localisation example file.^ KeyFile="*" EXLIST="DUTCH.ZIP">

   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       This example shows how CF vd Berg localised the MSIs created by
       MAKEMSI for the dutch language.

       Its quite likely that there are still english strings that need
       translation or that MAKEMSI has changed since this example was
       created, Please use this example as a guide as how localisation
       can be done.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>
<$MacroCfg "DEFAULT_ROW_VALIDATE_NO_WHERE" VALUE="FIELD">
    #define UNZIPPED_IMAGE_DIR   <$MAKEMSI_OTHER_DIR>\UnpackedZips\dutch.idt  ;;This directory ERASED then recreated
    <$UnzipImage ZipFile="<$DUTCH.ZIP>" Dir="<$UNZIPPED_IMAGE_DIR>">
    <$Files "<$UNZIPPED_IMAGE_DIR>\*.NLD" EXLIST="EX_NLDDIR" DESTDIR="SAMPLESRELDIR_TRYME_CREATE_MSI_DUTCH" SubDir="TREE" Comment=^Windows Installer ".IDT" files with dutch text, imported by "TryMe_Dutch.MM" to convert text from english.^>
    <$Files "<$UNZIPPED_IMAGE_DIR>\*.*"   EXLIST="EX_NLDDIR" DESTDIR="SAMPLESRELDIR_TRYME_CREATE_MSI_DUTCH" SubDir="TREE" Comment=^Part of the dutch example.^>
<$/MacroCfg>



;----------------------------------------------------------------------------
;--- SAMPLES - TRYME MSM (Merge Module) -------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="SAMPLESDIR_TRYME_CREATE_MSM"  Dir="[SAMPLESDIR]\<$SAMPLESRELDIR_TRYME_CREATE_MSM>">
<$Component "SAMPLESDIR_TRYME_CREATE_MSM" Create="Y" Directory_="SAMPLESDIR_TRYME_CREATE_MSM">
    ;--- Sample Merge Modules -----------------------------------------------
    <$Files "TryMeCreateMergeModule.*" Comment="Simple Sample to create a merge module." KeyFile="*">

   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       This directory contains sample merge module creation scripts which
       you should be able to execute to successfully build a ".MSM" file.
       Right click on the ".MM" file and select a build option.

       They are supplied so that within minutes of installing MAKEMSI you could
       have created your first working MSM.

       The scripts provide a working starting point which you can modify to test
       changes while you are learning MAKEMSI.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>



;----------------------------------------------------------------------------
;--- SAMPLES - TRYME CUB (Validation Databases, for ORCA, MSIVAL2) ----------
;----------------------------------------------------------------------------
<$DirectoryTree Key="SAMPLESDIR_TRYME_CUB"  Dir="[SAMPLESDIR]\<$SAMPLESRELDIR_TRYME_CREATE_CUB>">
<$Component "SAMPLESDIR_TRYME_CUB" Create="Y" Directory_="SAMPLESDIR_TRYME_CUB">
    ;--- Sample Merge Modules -----------------------------------------------
       <$Files "ICE.mm"          Comment="Source for a working addition to normal MSI validations.">
       <$Files "IceAddToOrca.*"  Comment=^Used to Add the CUB generated by "ICE.MM" to the ORCA tool's menu.^>

   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       The "ICE.MM" script builds a new validation suite based on an existing
       one.  It adds a single extra validation and does some other manipulation
       on the original database.

       Note that the "ICE.MM" script expects (by default) that MSIVAL2
       (from the platform SDK) has been installed to the
       "C:\Program Files\MsiVal2" directory.

       The generate CUB file is suitable for use by MSIVAL2.EXE or "ORCA.EXE".

       The "IceAddToOrca.MM" script takes the "CUB" file generated by "ICE.MM"
       and creates an MSI which when installed makes the CUB file available
       via Microsoft's ORCA tool.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>



;----------------------------------------------------------------------------
;--- SAMPLES - UPDATE MSI ---------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="SAMPLESDIR_TRYME_UPDATE_DB"  Dir="[SAMPLESDIR]\<$SAMPLESRELDIR_TRYME_UPDATE_DB>">
<$Component "SAMPLESDIR_TRYME_UPDATE_DB" Create="Y" Directory_="SAMPLESDIR_TRYME_UPDATE_DB">
   <$Files "Tweek.mm" Comment="Source for a script which makes one simple change to an MSI." KeyFile="*">

   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       This directory contains sample scripts which update Windows Installer databases.

       Given that they need something to "work on", the "TRYME.MM" script must have
       been previously executed as this creates a database which the script will use.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>


;----------------------------------------------------------------------------
;--- "Regression Test" SAMPLES ----------------------------------------------
;----------------------------------------------------------------------------
<$Component "SAMPLESDIR_REGRESSION_TESTS" Create="Y" Directory_="[SAMPLESDIR_OTHER]\Regression Tests">
   <$Files "RegressionTests*.*"   Comment="Regression Test source code.">

   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       This contains sundry regression test scripts.
       I have installed them as they will also provide good examples.

       Feel free to send in any improvements...
   <$/ReadMe+ProgramFilesWarning>
<$/Component>


;----------------------------------------------------------------------------
;--- "OTHER SUNDRY" SAMPLES -------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="SAMPLESDIR_OTHER_SUNDRY"  Dir="[SAMPLESDIR_OTHER]\Sundry">
<$Component "SAMPLESDIR_OTHER_SUNDRY" Create="Y" Directory_="SAMPLESDIR_OTHER_SUNDRY">
   <$Files "FixMergeModules.mm"   Comment="Source for a script which fixes some badly written Visual Studio .NET merge modules.">

   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       This contains sundry scripts.

       I do not expect you to simply right click and build them
       (or in fact to build them at all), without performing appropriate
       modifications and work first.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>
<$Component "SAMPLESDIR_OTHER_SERVICE" Create="Y" Directory_="[SAMPLESDIR_OTHER_SUNDRY]\Service">
   <$Files "VbscriptBasedService.*"  Comment="Installs a VBSCRIPT based program as a service.">

   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       Complete script to install a VBSCRIPT based program as a service.

       You need to supply the "sc.exe" and "srvstart.exe" tools.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>
<$Component "SAMPLESDIR_OTHER_KB12345" Create="Y" Directory_="[SAMPLESDIR_OTHER_SUNDRY]\KB872942">
   <$Files "TryMeWindowsHotFix.MM"  Comment="Sample script for hotfix MSI creation (uses common version file).">


   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       For this script to complete you must obtain/download the
       KB872942 hotfix EXE from Microsoft.

       As a further example see the "COMMON FILES" subdirectory, this is
       a proposed structure for organising your hotfixes.
       If you download "qfecheck.exe", then the extended state logging will
       automically be added.

       This hot fix (KB872942) requires WINXP SP2 to install.

       In a "real" script I would not use the line:

             <?Space>    <?Hash>evaluate ^^ ^call IncludePath 'COMMON FILES'^

       But use the "MAKEMSI_USER_FILES_PATH" or other external
       configuration to point MAKEMSI at common files...
   <$/ReadMe+ProgramFilesWarning>
<$/Component>
<$Component "SAMPLESDIR_OTHER_KB12345_COMMON_FILES" Create="Y" Directory_="[SAMPLESDIR_OTHER_SUNDRY]\KB872942\COMMON FILES">
   <$Files "HotFix4WinXpSp2.mmh"    Comment=^Used by "TryMeWindowsHotFix.MM"^>
   <$Files "HotFix4WinXpSp2.ver"    Comment=^Used by "HotFix4WinXpSp2.mmh" (at least by default).^>
<$/Component>


;----------------------------------------------------------------------------
;--- MSI Policies -----------------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="MSI_POLICIES"  Dir="[INSTALLDIR]\Registry Policies">
<$Component "MSI_POLICIES" Create="Y" Directory_="MSI_POLICIES">
   <$File Source=^MsiLogging-ON.reg^  Comment="REGEDIT4 script to turn on verbose Windows Installer Logging (to temp directory)." KeyPath="Y">
   <$File Source=^MsiLogging-OFF.reg^ Comment="REGEDIT4 script to turn off Windows Installer Logging.">


   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       This directory contains REGEDIT4 scripts to modify Windows Installer
       options.

       Simply double click (and confirm) to install.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>



;----------------------------------------------------------------------------
;--- More Work --------------------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="MORE_WORK"  Dir="[INSTALLDIR]\More Work (or help) Required">
<$Component "MORE_WORK" Create="Y" Directory_="MORE_WORK">
   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe KeyFile=Y>
       I've started or possibly nearly completed some work but am stuck...

       See the "MAKEMSI.HTM" documentation (via control panel if you wish)
       to see any info about particular files in this directory.

       Also see the "Regression tests", if you want to create or improve any
       then feel free!

       Contact me for more details if required...
   <$/ReadMe+ProgramFilesWarning>
<$/Component><$DirectoryTree Key="MORE_WORK_CAPTURE_SELF_REGISTRATION"  Dir="[MORE_WORK]\Capture of Self Registration Information">
<$Component "MORE_WORK_CAPTURE_SELF_REGISTRATION" Create="Y" Directory_="MORE_WORK_CAPTURE_SELF_REGISTRATION">
   <$File Source=^SelfRegImport.MMH^   Comment=^Uses "SelfRegCapture.exe" to capture registry, exports and manipulates output (Intended to be used to pupulate "Registry" table with captured info).^>
   <$File Source=^selfreg_.mmh^        Comment=^Include by "SelfRegImport.MMH".^>

   ;--- Supporting MM/VER file ------------------------------------------------
   <$FileMake "<$MAKEMSI_OTHER_DIR>\SelfReg.MM">
       <?SemiColon>--- Load MAKEMSI (via wrapper) --------------------------------------
       <?Hash>include "DEPT.MMH"

       <?NewLine>
       <?SemiColon>--- Load Unfinished supporting code ---------------------------------
       <?Hash>include "SelfRegImport.MMH"

       <?NewLine>
       <?SemiColon>--- Try Code --------------------------------------------------------
       <<?_>$SelfRegImport "..\..\MakeMSI.DLL" INSTALLEDNAME="[INSTALLDIR]\makemsi.dll">
   <$/FileMake>
   <$FileMake "<$MAKEMSI_OTHER_DIR>\SelfReg.VER">
        <?SemiColon>++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        <?SemiColon> ProductName = SelfReg
        <?SemiColon> DESCRIPTION = SelfReg (contents of this file doesn't matter much).
        <?SemiColon> Installed   = WINDOWS_ALL
        <?SemiColon> Guid.UpgradeCode = {7FF333CB-3BB9-457D-831E-8482E50F2969}
        <?SemiColon>++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        <?NewLine>

        <?SemiColon>############################################################################
        VERSION : 3.076.0000
        DATE    : 17 Mar 2003
        CHANGES : This is a fictional second release of this MSI.
   <$/FileMake>
   <$File Source="<$MAKEMSI_OTHER_DIR>\SelfReg.VER" Comment=^Supporting VER file, details irrelevant!^>
   <$File Source="<$MAKEMSI_OTHER_DIR>\SelfReg.MM"  Comment=^Test script to exercise code.^>

   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       This demonstrates the capture of self registration information without
       actually self registering the executable and conversion of this to
       appropriate "Registry" commands.

       Build the "SelfReg.MM" script to test.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>


;----------------------------------------------------------------------------
;--- Files for "MmValidate.VBS" ---------------------------------------------
;----------------------------------------------------------------------------
<$CompPerFile "out\MmValidate.VBS"    Comment='Used for command line or explorer based validation.'>
<$CompPerFile "FFFE.HEX"              Comment='Used by "MmValidate.VBS".'>
#define DefaultFilterFile             <$MAKEMSI_OTHER_DIR>\MmValidate.FLT
<$FileMake "<$DefaultFilterFile>">
    #include "MakeMsi.FLT"
    #ifdef MAKEMSI_FLT_VERSION
           ;--- Remove the "I've already been included flag..." -------------
           #undef MAKEMSI_FLT_VERSION
    #elseif
           #error ^I expected to see the "MAKEMSI_FLT_VERSION" macro defined!^
    #endif
<$/FileMake>
<$CompPerFile "<$DefaultFilterFile>"  Comment='Default filter used by "MmValidate.VBS".'>


;----------------------------------------------------------------------------
;--- Other bits -------------------------------------------------------------
;----------------------------------------------------------------------------
<$CompPerFile "<$NAME_TEE.REX>"       Comment='Used during compile to capture cab compression details (for debugging only).'>
<$CompPerFile "<$NAME_PPWIZARD.REX>"  Comment='The PPWIZARD tool. A very powerful preprocessor (also used to generate the MAKEMSI documentation).'>
<$CompPerFile "<$NAME_REGINA.EXE>"    Comment='A renamed "regina.exe" (rexx interpreter), required by "PPWIZARD". File patched to load "<$NAME_REGINA.DLL>".'>
<$CompPerFile "<$NAME_REGINA.DLL>"    Comment='A renamed "regina.dll", required by "<$NAME_REGINA.EXE>" (rexx interpreter)'>
;<$CompPerFile "out\MsiVal2Fix.VBS"   Comment='Used to touch up MSIVAL2.EXE output.'>  ;;VBSCRIPT can't reliably read the output
<$CompPerFile "out\MmMD5.VBS"         Comment='Displays the MD5 hash for a file (useful for comparing against generated HTML reports).'>
<$CompPerFile "out\MmLockFile.VBS"    Comment='Can be used to lock a file to test Windows Installer Installation etc.'>
<$CompPerFile "out\OrcaView.VBS"      Comment='This tool is used for the right click MSI "view" option.'>
<$CompPerFile "out\_LogView.VBS"      Comment='Not intended for user use (used internally).'>
<$CompPerFile "out\_MM.VBS"           Comment='This is called via Explorer associations (used internally).'>
<$CompPerFile "CTEXT.EXE"             Comment='If exists, "PPWIZARD" will use for coloured console output.'>
<$CompPerFile "<?=FindFile('FindMult.vbs', '!')>" Comment='Used to filter MSI validation results.'>
<$CompPerFile "StrFInfo.exe"                  Comment=^Used to dump executable file information in the HTML report (not used for MSI version information in "File" table). Also see "MmDocumentProperties.VBS".^>
<$CompPerFile "out\MmDocumentProperties.VBS"  Comment=^Can be used to dump document properties of office or other files. Similar to "StrFInfo.exe"^>
<$CompPerFile "DtReg.exe"             Comment='Used by "SelfRegImport". Command line registry manipulation tool.'>
<$CompPerFile "DtReg.htm"             Comment='Documentation for "DTREG.EXE" (licence requires it be included).'>
<$CompPerFile "SelfRegCapture.exe"    Comment='Used by "SelfRegImport". Captures self registration info to HKCU\Software\RegSpy without registering the DLL etc.'>


;----------------------------------------------------------------------------
;--- Put MsiSync.VBS in a "safe location" -----------------------------------
;----------------------------------------------------------------------------
<$Component "MsiSync" Create="Y" Directory_="[INSTALLDIR]\MsiSyncTool">
   <$File Source="out\MsiSync.VBS" KeyPath="Y" Comment='A tool which you can use to keep installed MSIs up to date. A common file share could be updated with many MSIs which you want all users to have installed on their boxes. When executed this tool will look at all MSIs in the same tree as the VBS and install if required.'>
   <$File Source="MsiSync.XML"                 Comment='"MsiSync.VBS" xml Configuration file which safely points to a non-existant directory. Good example.'>
   <$File Source="MsiSync.XSD"                 Comment='Style sheet for the "MsiSync.VBS" XML configuration file.'>

   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe KeyFile=Y>
       I have placed the "MSISYNC.VBS" in a directory of its own as people
       were executing it before they understood what it was and what it
       does!

       The program is documented in the MAKEMSI manual but basically it can
       be used to install one or many MSI files, it will "syncronise" your
       computer with the MSI's in the directory tree.
       It will uninstall and install as required and order of installation
       can be controlled.

       As a second "safety" feature I have put an invalid directory as the
       MSI source directory in the XML configuration file.
   <$/ReadMe+ProgramFilesWarning>
<$/Component>



;----------------------------------------------------------------------------
;--- Bug Diagnostics --------------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="BUG_DIAGNOSTICS"  Dir="[INSTALLDIR]\Bug Diagnostics">
<$Component "BugDiagnostics" Create="Y" Directory_="BUG_DIAGNOSTICS">
    <$FileComment Comment="Can be used to test for a specific bug.">
        <$Files "BugDetectionForShortNameAttribute.vbs">
        <$Files "BugDetectionForRegExpFails.vbs">
        <$Files "BugDetectionForCreateObject.vbs">
        <$Files "$$$RunAllTests$$$.CMD" KeyFile="*">
    <$/FileComment>
    <$DirectoryTree Key="SCDIR_DIAGDIR" Dir="[SCDIR_MAKEMSI]\Diagnostics" Remove="Y">
    #(
       <$Shortcut
                   Dir="SCDIR_DIAGDIR"
               Feature="."                             ;;Advertise current
                 Title="General Script Tests"
           Description="Tests for assorted scripting issues I have seen."
                  Icon="@ScriptDiag.ico"
               WorkDir="BUG_DIAGNOSTICS"
       >
   #)


   ;--- Readme.txt ----------------------------------------------------------
   <$ReadMe>
       This directory contains bug detection code for some of the issues
       I have encountered and managed to create a simple detection script
       for.

       If you report an issue with MAKEMSI I may ask you to run one of
       these!
   <$/ReadMe+ProgramFilesWarning>
<$/Component>
<$DirectoryTree Key="DIAGDIR_ANTIVIRUS"  Dir="[BUG_DIAGNOSTICS]\Look4AntiVirusIssues">
<$Component "ShortCutDocoTestForAntiVirus" Create="Y" Directory_="DIAGDIR_ANTIVIRUS">
   <$File Source="OUT\_Anti.vbs" Comment='Run via shortcut to test for antivirus or anispyware issues' KeyPath="Y">
   #(
       <$Shortcut
                   Dir="SCDIR_DIAGDIR"
               Feature="."                             ;;Advertise current
                 Title="Test for AntiVirus Issues"
           Description="Tests for antivirus or antispyware issues."
                  Icon="@Anti.ico"
               WorkDir="INSTALLDIR"
       >
   #)
<$/Component>





;----------------------------------------------------------------------------
;--- Doco Shortcuts ---------------------------------------------------------
;----------------------------------------------------------------------------
;@@@[ChmShortcutsDisplayedInMakeMsiDoco]@@@
#(
   #define CHM
   The document is in Windows Compiled Help format and so
   has a contents, an index and can be searched.
#)
<$DirectoryTree Key="DOCODIR" Dir="[INSTALLDIR]\Documentation">
<$Icon KEY="@Help" ".\help.ico">
<$Component "ShortCutDocoMAKEMSI" Create="Y" Directory_="DOCODIR">
   <$DirectoryTree Key="SCDIR_DOCO" Dir="[SCDIR_MAKEMSI]\Documentation" Remove="Y">
   <$File Source="OUT\DOCO\MakeMsi\MakeMsi.chm" Comment='MAKEMSI documentation. <$CHM>' KeyPath="Y">
   #(
       <$Shortcut
                   Dir="SCDIR_DOCO"
               Feature="."                             ;;Advertise current
                 Title="MAKEMSI"
           Description="Documents the MAKEMSI tool (version <$ProductVersion>)."
                  Icon="@Help"
               WorkDir="INSTALLDIR"

       >
   #)
<$/Component>
;@@@[ChmShortcutsDisplayedInMakeMsiDoco]@@@
<$Component "ShortCutDocoPPWIZARD" Create="Y" Directory_="DOCODIR">
   <$File Source="C:\DBAREIS\Projects\MultiOs\PPWIZARD\OUT\ppwizard.chm" Comment='PPWIZARD documentation. <$CHM>' KeyPath="Y">
   #(
       <$Shortcut
                   Dir="SCDIR_DOCO"
               Feature="."                             ;;Advertise current
                 Title="PPWIZARD"
           Description="Documents the PPWIZARD tool"
                  Icon="@Help"
               WorkDir="INSTALLDIR"
       >
   #)
<$/Component>
<$Link2WindowsInstallerDoco "SCDIR_DOCO">
<$Component "ShortCutLicence" Create="Y" Directory_="DOCODIR">
   <$File Source="MakeMsi.Licence.RTF" Destination="Licence.rtf" Comment='The MAKEMSI licence file you agreed to during the install.' KeyPath="Y">
   <$Icon KEY="@Licence" ".\licence.ico">
   #(
       <$Shortcut
                   Dir="SCDIR_DOCO"
               Feature="."                             ;;Advertise current
                 Title="The MAKEMSI Licence"
           Description="You agreed to this licence during the install!"
                  Icon="@Licence"
               WorkDir="INSTALLDIR"
       >
   #)
<$/Component>


;----------------------------------------------------------------------------
;--- OPEN "SAMPLES" Folder Shortcut -----------------------------------------
;----------------------------------------------------------------------------
<$Icon KEY="@OSAMPLES" ".\OSamples.ico">
<$Component "ShortCutOpenSamples" Create="Y" Directory_="INSTALLDIR">
   <$File Source="out\OSamples.vbs" Comment='Opens the "samples" folder (your code is copied here).' KeyPath="Y">
   #(
       <$Shortcut
                   Dir="SCDIR_MAKEMSI"
               Feature="."                             ;;Advertise current
                 Title="Samples|Open YOUR SAMPLES directory"
           Description=^Opens YOUR "samples" folder (your code is copied here if you have defined its location).^
                  Icon="@OSAMPLES"
               WorkDir="INSTALLDIR"
       >
   #)
<$/Component>


;----------------------------------------------------------------------------
;--- NEW GUID ShortCut ------------------------------------------------------
;----------------------------------------------------------------------------
<$Icon KEY="@MmWiGuid" ".\MmWiGuid.ico">
<$Component "ShortCutMmWiGuid" Create="Y" Directory_="INSTALLDIR">
   <$File Source="out\MmWiGuid.vbs" Comment='Simple tool to create Windows Installer Guids, useful if you wish to specify guids in the VER file.' KeyPath="Y">
   #(
       <$Shortcut
                   Dir="SCDIR_MAKEMSI"
               Feature="."                             ;;Advertise current
                 Title="MmWiGuid|GUID Generation"
           Description="Generates new GUIDs which you can cut and paste into your code."
                  Icon="@MmWiGuid"
               WorkDir="INSTALLDIR"
       >
   #)
<$/Component>


;----------------------------------------------------------------------------
;--- Show Windows Installer Version -----------------------------------------
;----------------------------------------------------------------------------
<$Icon KEY="@VersionInformationBox" ".\VersionInformationBox.ico">
<$Component "ShortCutVersionInformationBox" Create="Y" Directory_="INSTALLDIR">
   <$File Source="out\VersionInformationBox.vbs" Comment='Simple tool to create Windows Installer Guids, useful if you wish to specify guids in the VER file.' KeyPath="Y">
   #(
       <$Shortcut
                   Dir="SCDIR_MAKEMSI"
               Feature="."                             ;;Advertise current
                       Title="Versions|Display Versions"
           Description="Display Windows, WSH & Windows Installer version information."
                  Icon="@VersionInformationBox"
               WorkDir="INSTALLDIR"
       >
   #)
<$/Component>



;----------------------------------------------------------------------------
;--- Mangle/Unmangle GUIDs --------------------------------------------------
;----------------------------------------------------------------------------
<$Icon KEY="@Mangled" ".\_Mangled.ico">
<$Component "ShortCutMangled" Create="Y" Directory_="INSTALLDIR">
   <$File Source="out\_Mangled.vbs" KeyPath="Y" Comment=^Converts GUIDs between MSI and "mangled" formats.^>
   #(
       <$Shortcut
                   Dir="SCDIR_MAKEMSI"
               Feature="."                             ;;Advertise current
                 Title="GUID Conversion"
           Description="Converts between MSI and mangled GUID formats."
                  Icon="@Mangled"
               WorkDir="INSTALLDIR"
       >
   #)
<$/Component>


;----------------------------------------------------------------------------
;--- Environment/path setup -------------------------------------------------
;----------------------------------------------------------------------------
<$Component "ENVIRONMENT_AND_REGISTRY_4_DOS" Condition="Version9X" Create="Y" Directory_="INSTALLDIR">
   ;--- Update the "PATH" ---------------------------------------------------
   <$Path '"[INSTALLDIR]"'>        ;;Dos requires quotes around directory, example "@PATH=blah;..." will fail if quotes missing)

   ;--- Component Key path --------------------------------------------------
   #(
       <$Registry
              HKEY="LOCAL_MACHINE"
               KEY="Software\MAKEMSI\KeyPaths"
              NAME="ENVIRONMENT_AND_REGISTRY_4_DOS"
           KEYPATH="Y"
       >
   #)
<$/Component>
<$Component "ENVIRONMENT_AND_REGISTRY_4_NT" Condition="not Version9X" Create="Y" Directory_="INSTALLDIR">
   ;--- Update the "PATH" ---------------------------------------------------
   <$Path '[INSTALLDIR]'>          ;;No special requirements for NT based

   ;--- Set up PATHEXT so Windows can find the rexx code --------------------
   <$Path ".<$EXTN_REXX>" NAME="PATHEXT">

   ;--- Component Key path --------------------------------------------------
   #(
       <$Registry
              HKEY="LOCAL_MACHINE"
               KEY="Software\MAKEMSI\KeyPaths"
              NAME="ENVIRONMENT_AND_REGISTRY_4_NT"
           KEYPATH="Y"
       >
   #)
<$/Component>
<$Component "ENVIRONMENT_AND_REGISTRY" Create="Y" Directory_="INSTALLDIR">
   ;--- Point to the install directory --------------------------------------
   <$Environment NAME="MAKEMSI_DIR" VALUE="[INSTALLDIR]">

   ;--- Point to the default location (users should not update, override macro instead) ---
   <$Environment NAME="MAKEMSI_MSIVAL2_DIR" VALUE="[ProgramFilesFolder]MSIVAL2">

   ;--- Tell "MSIDIFF" where a default MSI template is ----------------------
   <$Environment NAME="MAKEMSI_DB_COMPARE_TEMPLATE.MSI" VALUE="[INSTALLDIR]UiSample.MSI">

   ;--- Help PPWIZARD find the MAKEMSI headers ------------------------------
   <$Path "[INSTALLDIR]"  NAME="PPWIZARD_INCLUDE">

   ;--- Help regina find rexx code ------------------------------------------
   <$Path "[INSTALLDIR]"  NAME="REGINA_MACROS">

   ;--- Regina 3.3 RC2 is OK ------------------------------------------------
   ;<$Path "3.3RC2(MT)"  NAME="PPWIZARD_TEST_REGINA_VER" Delimiter=",">
   ;<$Path "3.3(MT)" NAME="PPWIZARD_TEST_REGINA_VER" Delimiter=",">
   <$Path "3.3(JULIAN)(MT)" NAME="PPWIZARD_TEST_REGINA_VER" Delimiter=",">

   ;--- Set up association for our "unusual" rexx code extension ------------
   <$File Destination="<$4MM.ICO>" Source="4mm.ico"  Comment="Icon for .4MM files (rexx files for MAKEMSI).">
   #(
       ;--- ".REX" association ----------------------------------------------
       <$Registry
           HKEY="CLASSES_ROOT"
               KEY=".<$EXTN_REXX>"
           VALUE="<$REXX_ProgID>"
           KEYPATH="Y"
       >
   #)
   #(
       ;--- ".REX" ftype ----------------------------------------------------
       <$Registry
                   HKEY="CLASSES_ROOT"
                    KEY="<$REXX_ProgID>\Shell\Open\Command"
                  VALUE=^"[INSTALLDIR]<$NAME_REGINA.EXE>" "%1" %*^
           MsiFormatted="VALUE"
       >
   #)
   #(
       ;--- The ICON --------------------------------------------------------
       <$Registry
                   HKEY="CLASSES_ROOT"
                    KEY="<$REXX_ProgID>\DefaultIcon"
                  VALUE=^[INSTALLDIR]<$4mm.ico>^
           MsiFormatted="VALUE"
       >
   #)
   <$Registry HKEY="CLASSES_ROOT" KEY="<$REXX_ProgID>\AlwaysShowExt" VALUE=^^>
<$/Component>


;----------------------------------------------------------------------------
;--- Handle/create ".RE4MM" files -------------------------------------------
;----------------------------------------------------------------------------
<$Component "ForNT_RE4MM" Create="Y" Directory_="INSTALLDIR" Condition="not Version9X">
    ;--- Add the "program" file ---------------------------------------------
    <$File Source="_re4mm.cmd" Comment=^Batch file to convert a regedit4 formatted file to MAKEMSI format (used via Explorer).^>
    <$File Source="re4mm.p"    Comment=^PPWIZARD script used by "_re4mm.cmd".^>

    ;--- Add the ICON files -------------------------------------------------
    <$File Destination="<$RE4MM.ICO>"  Source="re4mm.ico"   Comment=^Icon for .RE4MM files (exported ".reg" files converted to MAKEMSI format).^>

    ;--- Open ".RE4MM" files in a Text editor -------------------------------
    <$Extn ".RE4MM" ProgId="RE4MM" KEYPATH="Y" Description="Converted REGEDIT4 registry file" Icon="[INSTALLDIR]<$re4mm.ico>" AlwaysShow="Y">
        <$ExtnAction Key="Open" Description="Edit RE4MM file" Command=^[DEFAULT_TEXT_EDITOR_CMDLINE]^>
    <$/Extn>

    ;--- How to create ".RE4MM" files ---------------------------------------
    <$Extn ProgId="regfile">
    #(
        <$ExtnAction
                    Key="ZZZConvertToMakeMsiFormat"
            Description="Convert to MAKEMSI format"
                Command=^"[INSTALLDIR]_RE4MM.CMD" %1^
        >
    #)
    <$/Extn>
<$/Component>




;----------------------------------------------------------------------------
;--- Handle/create ".INIMM" files -------------------------------------------
;----------------------------------------------------------------------------
<$Component "ForNT_INIMM" Create="Y" Directory_="INSTALLDIR" Condition="not Version9X">
    ;--- Add the "program" file ---------------------------------------------
    <$File Source="_IniMM.cmd" Comment=^Batch file to convert a .INI file to MAKEMSI format (used via Explorer).^>
    <$File Source="IniMM.p"    Comment=^PPWIZARD script used by "_IniMM.cmd".^>

    ;--- Add the ICON files -------------------------------------------------
    <$File Destination="<$IniMM.ICO>"  Source="inimm.ico"   Comment=^Icon for .INIMM files (exported ".ini" files converted to MAKEMSI format).^>

    ;--- Open ".RE4MM" files in a Text editor -------------------------------
    <$Extn ".INIMM" ProgId="INIMM" KEYPATH="Y" Description="Converted INI file (MAKEMSI formatted)" Icon="[INSTALLDIR]<$inimm.ico>" AlwaysShow="Y">
        <$ExtnAction Key="Open" Description="Edit INIMM file" Command=^[DEFAULT_TEXT_EDITOR_CMDLINE]^>
    <$/Extn>

    ;--- How to create ".RE4MM" files ---------------------------------------
    <$Extn ProgId="inifile">
    #(
        <$ExtnAction
                    Key="ZZZConvertToMakeMsiFormat"
            Description="Convert to MAKEMSI format"
                Command=^"[INSTALLDIR]_INIMM.CMD" %1^
        >
    #)
    <$/Extn>
<$/Component>


;----------------------------------------------------------------------------
;--- Handle/create ".IDT" files ---------------------------------------------
;----------------------------------------------------------------------------
<$Component "ForNT_IDT2DEFN" Create="Y" Directory_="INSTALLDIR" Condition="not Version9X">
    ;--- Add the "program" file ---------------------------------------------
    <$File Source="out\_ExportDb.VBS" Comment='Exports a windows Installer database to .IDT (extracts binaries)' KeyPath="Y">
    <$File Source="_IDT2DEFN.cmd"     Comment=^Batch file to convert .IDT files to MAKEMSI table definitions format (used via Explorer).^>
    <$File Source="IDT2DEFN.p"        Comment=^PPWIZARD script used by "_IDT2DEFN.cmd".^>

    ;--- Open ".MmTable" files in a Text editor -----------------------------
    <$File Destination="<$IDT.ICO>"  Source="IDT.ICO"   Comment=^Icon for .RE4MM files (exported ".reg" files converted to MAKEMSI format).^>
    <$Extn ".MmTable" ProgId="MmTable" KEYPATH="Y" Description="MAKEMSI TableDefinition" Icon="[INSTALLDIR]<$IDT.ICO>" AlwaysShow="Y">
        <$ExtnAction Key="Open" Description="Edit TABLE DEFINITION file" Command=^[DEFAULT_TEXT_EDITOR_CMDLINE]^>
    <$/Extn>

    ;--- How to handle .IDT files -------------------------------------------
    <$Extn ProgId=".idt">
        <$ExtnAction Key="Open"                        Description="Edit TABLE DEFINITION file"    Command=^[DEFAULT_TEXT_EDITOR_CMDLINE]^>
        <$ExtnAction Key="ZZZConvertToMakeMsiTableDef" Description="Convert to MAKEMSI Table Defn" Command=^"[INSTALLDIR]_IDT2DEFN.CMD" %1^>
    <$/Extn>

    ;--- How are ".IDT" generated -------------------------------------------
    #{  SET ^TYPE={ }<$MSI_DATABASE_TYPES> Msi.Patch^
       ;--- Create a component for each type --------------------------------
       <$Component "RIGHT_CLICK_MSIEXPORT_<??SET_TYPE>_ALL" Create="Y" Directory_="INSTALLDIR">
           ;--- Export whole database ---------------------------------------
           #(
               <$Registry
                      HKEY="CLASSES_ROOT"
                       KEY="<??SET_TYPE>\shell\Z_MAKEMSI_38_MSIEXPORT"
                     VALUE="Export to .IDT"
                   KEYPATH="Y"
               >
           #)
           #(
               <$Registry
                       HKEY="CLASSES_ROOT"
                        KEY="<??SET_TYPE>\shell\Z_MAKEMSI_38_MSIEXPORT\command"
                      VALUE='"[WSCRIPT.EXE]" "[INSTALLDIR]_ExportDB.VBS" "%1"'
               MsiFormatted="VALUE"
               >
           #)
       <$/Component>
   #}
<$/Component>



;----------------------------------------------------------------------------
;--- PERUSER.VBS ------------------------------------------------------------
;----------------------------------------------------------------------------
<$Component "PerUser.VBS" Create="Y" Directory_="INSTALLDIR">
    <$File Source="out\PerUser.VBS"      Comment=^VBSCRIPT which will report per user installed products and identify the users (used SidToName.exe if available).^ KeyPath="Y">
    <$File Source="SidToName.exe"  Comment=^Free program from www.joeware.net (used by PerUser.VBS)^>
<$/Component>




;----------------------------------------------------------------------------
;--- MAKEMSI .MM , .MMH etc -------------------------------------------------
;----------------------------------------------------------------------------
#(
   <$Feature "MakeMsiAssociations"
            Directory_="INSTALLDIR"
                 Title="Associate .MM, .MMH & .VER"
           Description="MAKEMSI .MM, .MMH & .VER associations.
                        Allow you to easily edit scripts
                        and generate MSIs etc."
;;               Level="5"         ;;Not installed by default
   >
#)
   ;--- Work out the default text editor ------------------------------------
   <$FIND_DEFAULT_TEXT_EDITOR_CMDLINE>

    ;--- Set up some "right click" actions -----------------------------------
    <$Component "MakeMsiAssociations" Create="Y" Directory_="INSTALLDIR">
        ;--- Add the ICON files ---------------------------------------------
        <$File Destination="<$MM.ICO>"  Source="mm.ico"   Comment="Icon for .MMH files">
        <$File Destination="<$MMH.ICO>" Source="mmh.ico"  Comment="Icon for .MM files">
        <$File Destination="<$VER.ICO>" Source="ver.ico"  Comment="Icon for .VER files">

        ;--- Set up the associations ----------------------------------------
        <$Extn ".MM" ProgId="MAKEMSI.MM" KEYPATH="Y" Description="<$PROGID_MAKEMSI_MM>" Icon="[INSTALLDIR]<$mm.ico>" AlwaysShow="Y">
            <$ExtnAction Key="Open"           Description="Edit MAKEMSI Script"     Command=^[DEFAULT_TEXT_EDITOR_CMDLINE]^>
            <$ExtnAction Key="ZZ_100_Build_D" Description="Build MSI - Development" Command=^"[WSCRIPT.EXE]" "[INSTALLDIR]_MM.VBS" "%1" D^>
            <$ExtnAction Key="ZZ_100_Build_P" Description="Build MSI - Production"  Command=^"[WSCRIPT.EXE]" "[INSTALLDIR]_MM.VBS" "%1" P^>
        <$/Extn>
        <$Extn ".MMH" ProgId="MAKEMSI.MMH" Description="<$PROGID_MAKEMSI_MMH>" Icon="[INSTALLDIR]<$mmh.ico>" AlwaysShow="Y">
            <$ExtnAction Key="Open" Description="Edit MAKEMSI Header" Command=^[DEFAULT_TEXT_EDITOR_CMDLINE]^ >
        <$/Extn>
        <$Extn ".VER" ProgId="MAKEMSI.VER" Description="MAKEMSI Product/Version File" Icon="[INSTALLDIR]<$ver.ico>" AlwaysShow="Y">
            <$ExtnAction Key="Open" Description="Edit Product/Version FILE" Command=^[DEFAULT_TEXT_EDITOR_CMDLINE]^ >
        <$/Extn>
   <$/Component>
<$/Feature>



;----------------------------------------------------------------------------
;--- RIGHT CLICK Option for VIEWING with ORCA -------------------------------
;----------------------------------------------------------------------------
#(
   <$Feature "ViewMsiInOrca"
            Directory_="INSTALLDIR"
                 Title="View MSI in ORCA"
           Description="Right Click Explorer option.
                        Allows you to view a file without Orca
                        updating it (even when you don't change anything)!"
;;               Level="5"         ;;Not installed by default
   >
#)
   ;--- Set up some "right click" actions -----------------------------------
   <$Component "RIGHT_CLICK_ORCAVIEW" Create="Y" Directory_="INSTALLDIR">
       #{  SET ^TYPE={ }<$MSI_DATABASE_TYPES>^
           #(
               <$Registry
                   HKEY="CLASSES_ROOT"
                       KEY="<??SET_TYPE>\shell\Z_MAKEMSI_10_ORCA_VIEW"
                   VALUE="VIEW With Orca"
                   KEYPATH="Y"
               >
           #)
           #(
               <$Registry
                       HKEY="CLASSES_ROOT"
                        KEY="<??SET_TYPE>\shell\Z_MAKEMSI_10_ORCA_VIEW\command"
                      VALUE='"[WSCRIPT.EXE]" "[INSTALLDIR]OrcaView.VBS" "%1" %*'
               MsiFormatted="VALUE"
               >
           #)
       #}
   <$/Component>
<$/Feature>



;----------------------------------------------------------------------------
;--- RIGHT CLICK Option for MSI/MSM Validation ------------------------------
;----------------------------------------------------------------------------
#(
   <$Feature "MmValidate"
            Directory_="INSTALLDIR"
                 Title="Validate MSI/MSM"
           Description="Right Click Explorer option.
                        Allows you to verify an MSI or merge module."
;;               Level="5"         ;;Not installed by default
   >
#)
   ;--- Set up some "right click" actions -----------------------------------
   <$Component "RIGHT_CLICK_MMVALIDATE" Create="Y" Directory_="INSTALLDIR" Condition="not Version9X">
       #{  SET ^TYPE={ }<$PROGIDS_MSI> <$PROGIDS_MSM>^
           #(
               <$Registry
                   HKEY="CLASSES_ROOT"
                       KEY="<??SET_TYPE>\shell\Z_MAKEMSI_15_MMVALIDATE"
                   VALUE="Validate It"
                   KEYPATH="Y"
               >
           #)
           #(
               <$Registry
                       HKEY="CLASSES_ROOT"
                        KEY="<??SET_TYPE>\shell\Z_MAKEMSI_15_MMVALIDATE\command"
                      VALUE='"[CSCRIPT.EXE]" //NoLogo "[INSTALLDIR]MmValidate.VBS" /ErrorsInMsgBox "%1"'
               MsiFormatted="VALUE"
               >
           #)
       #}
   <$/Component>
<$/Feature>



;----------------------------------------------------------------------------
;--- RIGHT CLICK Option -> New Command prompt -------------------------------
;----------------------------------------------------------------------------
#define NEW_CMD_PROMPT_KEY   aaaa-NewCmdPrompt
#(
   <$Feature "NewCommandPrompt"
            Directory_="INSTALLDIR"
                 Title="New Command Prompt"
           Description="Right Click -> NEW Command Prompt Explorer option.
                        Allows you to open a command prompt easily!"
;;               Level="5"         ;;Not installed by default
   >
#)
   ;--- Set up some "right click" actions -----------------------------------
   <$Component "RIGHT_CLICK_NEW_CMDPROMPT" Create="Y" Directory_="INSTALLDIR" Condition="not Version9X">
       #(
           ;--- Need to define an extension (use "dummy") -------------------
           <$Registry
               HKEY="CLASSES_ROOT"
                KEY=".<$NEW_CMD_PROMPT_KEY>"
              VALUE="<$NEW_CMD_PROMPT_KEY>"
               KEYPATH="Y"
           >
       #)
       #(
           ;--- The "NEW" command to execute --------------------------------
           <$Registry
               HKEY="CLASSES_ROOT"
                KEY=".<$NEW_CMD_PROMPT_KEY>\ShellNew"
               NAME="Command"
              VALUE=^"%COMSPEC%" /K ""[INSTALLDIR]CmdPrompt.cmd" "%1""^
       MsiFormatted="VALUE"
           >
       #)
       <$File Source="CmdPrompt.ico"  Destination="<$CMDPROMPT.ICO>" Comment="Icon for New->Command Prompt">
       <$File Source="CmdPrompt.cmd"                                 Comment="Command for New->Command Prompt">
       #(
           ;--- "NEW" descriptive text --------------------------------------
           <$Registry
               HKEY="CLASSES_ROOT"
                KEY="<$NEW_CMD_PROMPT_KEY>"
              VALUE=^Command Prompt (here)^
           >
       #)
       #(
           ;--- The "NEW" icon ----------------------------------------------
           <$Registry
               HKEY="CLASSES_ROOT"
                KEY="<$NEW_CMD_PROMPT_KEY>\DefaultIcon"
              VALUE=^[INSTALLDIR]<$CmdPrompt.ico>^
       MsiFormatted="VALUE"
           >
       #)
       #(
           ;--- WIN2000 needs "OPEN" entry for "NEW" item to appear ---------
           <$Registry
               HKEY="CLASSES_ROOT"
                KEY="<$NEW_CMD_PROMPT_KEY>\Shell\Open\Command"
              VALUE=^"%COMSPEC%" /c echo **** OOPS: %1 & pause^  ;;Anything will do (extension never used)
       MsiFormatted="VALUE"
           >
       #)


   <$/Component>
<$/Feature>





;**    [CommentBlockStart     (July 3, 2004 10:45:20 AM EST, Dennis)
;**+----------------------------------------------------------------------
;**|;----------------------------------------------------------------------------
;**|;--- RIGHT CLICK Dump with MSIDIFF.VBS ------------------------------------------
;**|;----------------------------------------------------------------------------
;**|#(
;**|   <$Feature "RightClickMsiDump"
;**|            Directory_="INSTALLDIR"
;**|                 Title="Disassembler"
;**|           Description="Right Click Explorer option.
;**|                        This dumps an MSI (or any Windows Installer
;**|                        database) into a text file."
;**|;;               Level="5"         ;;Not installed by default
;**|   >
;**|#)
;**|   ;--- Set up some "right click" actions -----------------------------------
;**|   #{  SET ^TYPE={ }<$MSI_DATABASE_TYPES> Msi.Patch <$MSI_TRANSFORM_TYPES>^
;**|       ;--- Create a component for each type --------------------------------
;**|       <$Component "RIGHT_CLICK_MSIDUMP_<??SET_TYPE>_ALL" Create="Y" Directory_="INSTALLDIR">
;**|           ;--- Dump Whole Database -----------------------------------------
;**|           #(
;**|               <$Registry
;**|                      HKEY="CLASSES_ROOT"
;**|                       KEY="<??SET_TYPE>\shell\Z_MAKEMSI_30_MSIDIFF"
;**|                     VALUE="Dump -> MAKEMSI format"
;**|                   KEYPATH="Y"
;**|               >
;**|           #)
;**|           #(
;**|               <$Registry
;**|                       HKEY="CLASSES_ROOT"
;**|                        KEY="<??SET_TYPE>\shell\Z_MAKEMSI_30_MSIDIFF\command"
;**|                      VALUE='"[WSCRIPT.EXE]" "[INSTALLDIR]_CompMsi.VBS" D "%1"'
;**|               MsiFormatted="VALUE"
;**|               >
;**|           #)
;**|       <$/Component>
;**|   #}
;**|   #{  SET ^TYPE={ }<$MSI_DATABASE_TYPES> Msi.Patch^
;**|       <$Component "RIGHT_CLICK_MSIDUMP_<??SET_TYPE>_DIFF" Create="Y" Directory_="INSTALLDIR">
;**|           #(
;**|               <$Registry
;**|                      HKEY="CLASSES_ROOT"
;**|                       KEY="<??SET_TYPE>\shell\Z_MAKEMSI_35_MSIDIFF_TEM"
;**|                     VALUE="Compare -> MAKEMSI format"
;**|                   KEYPATH="Y"
;**|               >
;**|           #)
;**|           #(
;**|               <$Registry
;**|                       HKEY="CLASSES_ROOT"
;**|                        KEY="<??SET_TYPE>\shell\Z_MAKEMSI_35_MSIDIFF_TEM\command"
;**|                      VALUE='"[WSCRIPT.EXE]" "[INSTALLDIR]_CompMsi.VBS" C "%1"'
;**|               MsiFormatted="VALUE"
;**|               >
;**|           #)
;**|       <$/Component>
;**|   #}
;**|<$/Feature>
;**+----------------------------------------------------------------------
;**    CommentBlockEnd]       (July 3, 2004 10:45:20 AM EST, Dennis)



;----------------------------------------------------------------------------
;--- RIGHT CLICK MSI LOGGING Options ----------------------------------------
;----------------------------------------------------------------------------
#(
   <$Feature "MsiVerboseLogging"
            Directory_="INSTALLDIR"
                 Title="Verbose MSI/MSP Logging"
           Description="Right Click Explorer option.
                        Very useful for diagnosing install problems.
                        Highly recommended."
;;               Level="5"         ;;Not installed by default
   >
#)
   ;--- Set up some "right click" actions -----------------------------------
   #(
        #define VERBOSE_LOGGING
        #(
           <$Registry
               HKEY="CLASSES_ROOT"
                   KEY="{$#1}\shell\Z_MAKEMSI_20_INSTALL_VERBOSE"
               VALUE="Install - &VERBOSE Logging!"
           >
       #)
       #(
           <$Registry
                   HKEY="CLASSES_ROOT"
                    KEY="{$#1}\shell\Z_MAKEMSI_20_INSTALL_VERBOSE\command"
                  VALUE='"[SystemFolder]msiexec.exe" {$Switches} "%1" /l*v "%1.MsiLog" %*'
           MsiFormatted="VALUE"
                KEYPATH="Y"
           >
       #)
   #)
   <$Component "RIGHT_CLICK_VERBOSE" Create="Y" Directory_="INSTALLDIR">
        <$Registry HKEY="CLASSES_ROOT" KEY=".MsiLog" VALUE="txtfile" KeyPath="Y">
        <$VERBOSE_LOGGING "Msi.Patch"   Switches="/p">
        <$VERBOSE_LOGGING "Msi.Package" Switches="/i">
   <$/Component>
<$/Feature>




;----------------------------------------------------------------------------
;--- RIGHT CLICK MSI MENU Options ----------------------------------------
;----------------------------------------------------------------------------
#(
   <$Feature "MsiRightClickMenu"
            Directory_="INSTALLDIR"
                 Title="MSI Menu"
           Description="Right Click Explorer option.
                        Very useful for diagnosing install problems.
                        Highly recommended."
;;               Level="5"         ;;Not installed by default
   >
#)
   ;--- Set up some "right click" actions -----------------------------------
   #(
        #define MSI_MENU
        #(
           <$Registry
                HKEY="CLASSES_ROOT"
                 KEY="{$#1}\shell\Z_MAKEMSI_25_MSI_MENU"
               VALUE="MSI MENU..."
           >
       #)
       #(
           <$Registry
                   HKEY="CLASSES_ROOT"
                    KEY="{$#1}\shell\Z_MAKEMSI_25_MSI_MENU\command"
                  VALUE='"[MSHTA_EXE]" "[INSTALLDIR]MsiExecMm.hta" (=)%1(=)[INSTALLDIR]MenuMsi.INI(=)'
           MsiFormatted="VALUE"
                KEYPATH="Y"
           >
       #)
   #)
   <$FileFind File="Mshta.EXE" Property="MSHTA_EXE" Default="!" PATH="[SystemFolder]" Depth="0">
   #define CONDITION_CAN_USE_HTA            VersionNT and MSHTA_EXE
   <$Component "RIGHT_CLICK_VERBOSE.CMD" Create="Y" Directory_="INSTALLDIR" Condition="<$CONDITION_CAN_USE_HTA>">
       <$MSI_MENU "Msi.Package">
       <$IniFile "MenuMsi.INI" DIR="[INSTALLDIR]">
           <$IniSection "MAKEMSI">
                #define MmMenuItem  <$Ini #1=^{$SortKey}^ Value=^{$Visible}|{$Cmd}^>
                ;----[4DocoMmMenuItems]---
                <$MmMenuItem SortKey=^Install^               Visible=^Normal Installation^                          Cmd=^{?:MSIEXEC.EXE} /i "{?}" /l*v "{?}.INST.MsiLog"^>
                <$MmMenuItem SortKey=^Install-10-Silent^     Visible=^Basic Installation^                           Cmd=^{?:MSIEXEC.EXE} /i "{?}" /l*v "{?}.BINST.MsiLog" /qb^>
                <$MmMenuItem SortKey=^Install-20-Silent^     Visible=^Silent Installation^                          Cmd=^{?:MSIEXEC.EXE} /i "{?}" /l*v "{?}.SINST.MsiLog" /qn^>
                <$MmMenuItem SortKey=^Install-30-PerMachine^ Visible=^Normal Installation (PER-MACHINE)^            Cmd=^{?:MSIEXEC.EXE} /i "{?}" /l*v "{?}.InstPm.MsiLog" ALLUSERS=1^>
                <$MmMenuItem SortKey=^Install-40-PerUser^    Visible=^Normal Installation (PER-USER)^               Cmd=^{?:MSIEXEC.EXE} /i "{?}" /l*v "{?}.InstPu.MsiLog" ALLUSERS=""^>
                <$MmMenuItem SortKey=^Install-70-Admin^      Visible=^Administrative Installation^                  Cmd=^{?:MSIEXEC.EXE} /a "{?}" /l*v "{?}.ADMIN.MsiLog"^>
                <$MmMenuItem SortKey=^Install-80-Admin_HERE^ Visible=^Administrative Installation - Extract "HERE"^ Cmd=^{?:MSIEXEC.EXE} /a "{?}" /l*v "{?}.ADMIN.MsiLog" TARGETDIR="{!:MD}{?:P}\AdminInstall\{?:B}{!:MD}"^>
                <$MmMenuItem SortKey=^Uninstall^             Visible=^Uninstallation^                               Cmd=^{?:MSIEXEC.EXE} /x "{?}" /l*v "{?}.UNINST.MsiLog"^>
                ;----[4DocoMmMenuItems]---
           <$/IniSection>
       <$/IniFile>
   <$/Component>
   <$Component "RIGHT_CLICK_VERBOSE.MSHTA" Create="Y" Directory_="INSTALLDIR" Condition="<$CONDITION_CAN_USE_HTA>">
        <$File source="out\MsiExecMm.hta" KeyPath="Y">
        <$File source="MsiExecMm.ico">
   <$/Component>
<$/Feature>


;----------------------------------------------------------------------------
;--- VERBOSE LOG VIEWER -----------------------------------------------------
;----------------------------------------------------------------------------
#(
   <$Feature "VerboseLogViewer"
            Directory_="INSTALLDIR"
                 Title="Verbose Log Viewer"
           Description=^Right Click Explorer option.
                        Uses the Microsoft SDK "WILOGUTL.EXE" program to
                        view verbose logs.^
;;               Level="5"         ;;Not installed by default
   >
#)
    ;--- Find the SDK utility and point an environment variable to it -------
    <$FileFind File="WiLogUtl.EXE" Property="WILOGUTL_EXE" Default="!" PATH="[ProgramFilesFolder]" Depth="3">
    <$Component "ENVIRONMENT_WiLogUtl.EXE" Create="Y" Directory_="INSTALLDIR" LM="Y" Condition=^WILOGUTL_EXE <> "!"^>
       <$Environment NAME="MAKEMSI_WILOGUTL_EXE" VALUE="[WILOGUTL_EXE]">
    <$/Component>

    ;--- Set up some "right click" actions -----------------------------------
   <$Component "RIGHT_CLICK_VIEW_LOG" Create="Y" Directory_="INSTALLDIR">
       #(
           <$Registry
               HKEY="CLASSES_ROOT"
                   KEY="txtfile\shell\Z_MAKEMSI_20_VIEW_VERBOSE_LOG"
               VALUE="View Verbose MSI Log"
               KEYPATH="Y"
           >
       #)
       #(
           <$Registry
                   HKEY="CLASSES_ROOT"
                    KEY="txtfile\shell\Z_MAKEMSI_20_VIEW_VERBOSE_LOG\command"
                  VALUE='"[WSCRIPT.EXE]" "[!_LogView.VBS]" "%1"'
           MsiFormatted="VALUE"
           >
       #)
   <$/Component>
<$/Feature>


;----------------------------------------------------------------------------
;--- FILE INFO --------------------------------------------------------------
;----------------------------------------------------------------------------
#(
   <$Feature "DisplayFileInfo"
            Directory_=""
                 Title="Display File Properties"
           Description=^Useful Explorer option for displaying file properties
                        that can be displayed in the generated HTML report.^
;;               Level="5"         ;;Not installed by default
   >
#)
   <$Component "FileInfoSendToIconForNT" Condition="not Version9X" Create="Y" Directory_="INSTALLDIR_PERUSER" CU="Y">
        ;--- Add as a user file (so only deleted if shortcut is!) -----------
        <$File source="FileInfo.cmd"                  Comment=^Dumps STRFINFO and Document Properties for a file.^>
        <$File source="StrFInfo.exe"                  Comment=^Used to dump executable file information in the HTML report (not used for MSI version information in "File" table). Also see "MmDocumentProperties.VBS".^>
        <$File source="out\MmDocumentProperties.VBS"  Comment=^Can be used to dump document properties of office or other files. Similar to "StrFInfo.exe"^>
        <$Icon KEY="@FileInfo" ".\FileInfo.ico">
        #(
            <$Shortcut
                       Dir="SendToFolder"
                    Target="[INSTALLDIR_PERUSER]FileInfo.cmd"
                     Title="Display File Properties"
               Description="Displays file properties (version <$ProductVersion>)."
                      Icon="@FileInfo"
                   WorkDir="INSTALLDIR_PERUSER"
                   ShowCmd="SHOWMINNOACTIVE"
            >
        #)
   <$/Component>
   <$MsiValFilter "will be installed to the per user directory" Comment=^Not true, this MSI installs per-machine^>
<$/Feature>


;----------------------------------------------------------------------------
;--- MD5 stuff --------------------------------------------------------------
;----------------------------------------------------------------------------
#(
   <$Feature "GenerateMD5"
            Directory_="INSTALLDIR"
                 Title="Generate MD5"
           Description=^Useful Explorer option for comparing files
                        ("Send To" shortcut or "right click" option for DOS).
                        Note that MAKEMSI generated HTML reports list
                        MD5 information for files.^
;;               Level="5"         ;;Not installed by default
   >
#)
   ;--- DOS -----------------------------------------------------------------
   <$Component "Md5RightClickForDos" Condition="Version9X" Create="Y" Directory_="INSTALLDIR">
       <$Extn ProgId="AllFilesystemObjects">
              <$ExtnAction Key="ZMAKEMSI_MD5" Description="Display MD5" Command=^"[WSCRIPT.EXE]" "[INSTALLDIR]MmMD5.VBS" "%1"^ KEYPATH="Y">
       <$/Extn>
   <$/Component>

   ;--- NT ------------------------------------------------------------------
   #define SendToShortCutName   Display MD5
   #define SendToShortCutDesc   Calculate the MD5 values for file(s)
   <$Component "MD5SendToIconForNT" Condition="not Version9X" Create="Y" Directory_="INSTALLDIR_PERUSER" CU="Y">
        ;--- Add as a user file (so only deleted if shortcut is!) -----------
        <$File source="out\MmMD5.vbs" Comment=^Displays MD5 for file.^>
        #(
            <$Shortcut
                       Dir="SendToFolder"
                    Target="[INSTALLDIR_PERUSER]MmMD5.vbs"
                     Title="<$SendToShortCutName>"
               Description="<$SendToShortCutDesc>."
                      Icon="@5.ico"
                   WorkDir="INSTALLDIR_PERUSER"
                   ShowCmd="SHOWMINNOACTIVE"
            >
        #)
   <$/Component>
   <$MsiValFilter "will be installed to the per user directory" Comment=^Not true, this MSI installs per-machine^>


;**    [CommentBlockStart     (September 16, 2005 5:26:26 PM EST, Dennis)
;**+----------------------------------------------------------------------
;**|   <$Component "Md5SendToIconForNT" Condition="not Version9X" Create="Y" Directory_="INSTALLDIR">
;**|       <$File source="5.ico" KeyPath="Y">
;**|   <$/Component>
;**|   <$Component "Md5SendToForNT" Condition="not Version9X" Create="Y" Directory_="INSTALLDIR" ComponentId="">  ;;VBS must continue to run after our uninstall (to remove the shortcuts)
;**|       ;--- Create the VBS --------------------------------------------------
;**|       #define  @@VBS_NAME <$SendToShortCutName>.VBS
;**|       <$FileMake "<$MAKEMSI_VBSCRIPT_DIR>\<$@@VBS_NAME>">
;**|           ;--- Insert Syntax Checking Stub here ----------------------------
;**|           <?SyntaxCheck>
;**|           <?NewLine>
;**|
;**|           ;--- Get the parameters ------------------------------------------
;**|           #define HKLM_RUN_DISPLAY_MD5_KEY       SOFTWARE\Microsoft\Windows\CurrentVersion\Run
;**|           #define HKLM_RUN_DISPLAY_MD5_VALUENAME MAKEMSI
;**|           if  wscript.arguments.count <> 3 then
;**|               dim Title : Title = "<$@@VBS_NAME> (MAKEMSI v<$ProductVersion>)"
;**|               dim Text  : Text = "MAKEMSI user setup failed. "
;**|               Text = Text & "An incorrect number of arguments was passed to ""<$@@VBS_NAME>"" "
;**|               Text = Text & "(we expected 3). This script is normally executed during Windows logon processing "
;**|               Text = Text & "(see ""HKLM\<$HKLM_RUN_DISPLAY_MD5_KEY>\<$HKLM_RUN_DISPLAY_MD5_VALUENAME>"")."
;**|               Text = Text & vbCRLF & vbCRLF & "We were passed " & wscript.arguments.count & " parameters"
;**|               if   wscript.arguments.count = 0 then
;**|                    Text = Text & "."
;**|               else
;**|                    Text = Text & ":" & vbCRLF
;**|                    dim i
;**|                    for i = 0 to wscript.arguments.count-1
;**|                        Text = Text & vbCRLF & "#" & i+1 & ": " & wscript.arguments(i)
;**|                    next
;**|               end if
;**|               msgbox Text, VbWarning, Title
;**|               wscript.quit 999
;**|           end if
;**|           dim ProductCode : ProductCode = wscript.arguments(0)
;**|           dim InstallDir  : InstallDir  = wscript.arguments(1)
;**|           dim RegVersion  : RegVersion  = wscript.arguments(2)     'Not used but will be displayed in the above diagnostic
;**|
;**|           ;--- Initialization ----------------------------------------------
;**|           dim oInstaller : set oInstaller = CreateObject("WindowsInstaller.Installer")
;**|           dim oShell     : set oShell     = CreateObject("WScript.Shell")
;**|           dim oFs        : set oFs        = CreateObject("Scripting.FileSystemObject")
;**|
;**|           ;--- Ignore any (other) errors -----------------------------------
;**|           on error resume next
;**|
;**|           ;--- Work out the shortcut name ----------------------------------
;**|           dim ShortcutFile, TargetFile, IconFile
;**|           ShortcutFile  = oShell.SpecialFolders("SendTo") & "\<$SendToShortCutName>.lnk"
;**|           TargetFile    = InstallDir & "MmMD5.VBS"
;**|           IconFile      = InstallDir & "5.ico"
;**|
;**|           ;--- Create or delete the icon -----------------------------------
;**|           const msiInstallStateDefault =  5
;**|           dim ProductState : ProductState = oInstaller.ProductState(ProductCode)
;**|           if  ProductState <> msiInstallStateDefault then
;**|               ;--- Delete the shortcut -------------------------------------
;**|               if  oFs.FileExists(ShortcutFile) then
;--- |                   ;--- Shortcut exists so delete it ------------------
;**|                   oFs.DeleteFile ShortcutFile
;**|               end if
;**|           else
;**|               ;--- Create the shortcut -------------------------------------
;**|               set oSc = oShell.CreateShortcut(ShortcutFile)
;**|               oSc.TargetPath       = TargetFile
;**|               oSc.WindowStyle      = 1
;**|               oSc.Description      = "<$SendToShortCutDesc>"
;**|               oSc.WorkingDirectory = InstallDir
;**|               oSc.IconLocation     = IconFile & ",0"
;**|               oSc.Save
;**|           end if
;**|       <$/FileMake>
;**|
;**|       ;--- Add the VBS to the component ------------------------------------
;**|       <$File RowKey="SendToMd5.vbs" source="<$MAKEMSI_VBSCRIPT_DIR>\<$@@VBS_NAME>" COMMENT=^Run at user logon to create or delete the MD5 "Send To" shortcut.  This file and the "run" registry entry not removed at uninstall.^>
;**|
;**|       ;--- Setup the registry to run our VBS -------------------------------
;**|       #(
;**|           ;--- MSI version passed for sanity checks on error ---------------
;**|           <$Registry
;**|                   HKEY="LOCAL_MACHINE"
;**|                    Key="<$HKLM_RUN_DISPLAY_MD5_KEY>"
;**|                   Name='<$HKLM_RUN_DISPLAY_MD5_VALUENAME>'
;**|                  Value=^[!SendToMd5.vbs] "[ProductCode]" "[INSTALLDIR]" "<$ProductVersion>"^
;**|           MsiFormatted="VALUE"
;**|                KeyPath="Y"
;**|           >
;**|       #)
;**|   <$/Component>
;**+----------------------------------------------------------------------
;**    CommentBlockEnd]       (September 16, 2005 5:26:26 PM EST, Dennis)
<$/Feature>




;----------------------------------------------------------------------------
;--- MAKEMSI ActiveX Control ------------------------------------------------
;----------------------------------------------------------------------------
#(
   <$Feature "InstallActiveXDll"
            Directory_="INSTALLDIR"
                 Title="Install ActiveX DLL"
           Description=^Useful but optional DLL.
                        Install unless for some reason you
                        need to prevent it (playing safe for now).^
;;               Level="5"         ;;Not installed by default
   >
#)
    <$Component "ActiveXControl" Create="Y" Directory_="INSTALLDIR">
        <$File RowKey="MakeMSI.DLL" Source="..\MAKEMSI_ActiveXControl\out\MakeMSI.DLL" Comment=^MAKEMSI Active-X DLL.^ KeyPath="Y">
    <$/Component>
    <$SelfRegister "MakeMSI.DLL">
<$/Feature>
<$Table "Condition">
#(
    ;--- Disable this feature if the required DLL can't be located ----------
    <$Row
           Feature_="InstallActiveXDll"
              Level="0"
          Condition=^not MSVBVM60.DLL^
    >
#)
<$/Table>
